using System;
using System.Drawing;
using System.Collections;
using System.Data;
using System.Data.SqlClient;
using System.ComponentModel;
using System.Windows.Forms;

using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Summary description for FrmEditUnitProcessingTestHarness
	/// </summary>
	public class FrmEditUnitProcessingTestHarness : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private string UI_MESSAGE =  "This business rule has been implemented in the Presentation Layer. Please, use the Edit Unit Processing form to test it.";
		private string NEWLINE = Environment.NewLine;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.ListBox lvBusinessRules;
		private System.Windows.Forms.Button btnRun;
		private System.Windows.Forms.GroupBox groupBox2;
		private System.Windows.Forms.Button btnClose;
		private gov.va.med.vbecs.GUI.controls.SpecialTesting specialTesting1;
		private System.Windows.Forms.TextBox txtBusinessRule;
		private System.Windows.Forms.TextBox txtResults;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		/// <summary>
		/// Constructor
		/// </summary>
		public FrmEditUnitProcessingTestHarness()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.txtBusinessRule = new System.Windows.Forms.TextBox();
			this.lvBusinessRules = new System.Windows.Forms.ListBox();
			this.btnRun = new System.Windows.Forms.Button();
			this.groupBox2 = new System.Windows.Forms.GroupBox();
			this.txtResults = new System.Windows.Forms.TextBox();
			this.btnClose = new System.Windows.Forms.Button();
			this.specialTesting1 = new gov.va.med.vbecs.GUI.controls.SpecialTesting();
			this.groupBox1.SuspendLayout();
			this.groupBox2.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(888, 30);
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 518);
			this.lblRequiredField.Name = "lblRequiredField";
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.Add(this.txtBusinessRule);
			this.groupBox1.Controls.Add(this.lvBusinessRules);
			this.groupBox1.Location = new System.Drawing.Point(8, 30);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(392, 466);
			this.groupBox1.TabIndex = 1;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Test Cases";
			// 
			// txtBusinessRule
			// 
			this.txtBusinessRule.Location = new System.Drawing.Point(8, 216);
			this.txtBusinessRule.Multiline = true;
			this.txtBusinessRule.Name = "txtBusinessRule";
			this.txtBusinessRule.ReadOnly = true;
			this.txtBusinessRule.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
			this.txtBusinessRule.Size = new System.Drawing.Size(376, 240);
			this.txtBusinessRule.TabIndex = 2;
			this.txtBusinessRule.Text = "";
			// 
			// lvBusinessRules
			// 
			this.lvBusinessRules.ItemHeight = 14;
			this.lvBusinessRules.Items.AddRange(new object[] {
																 "BR_70.01",
																 "BR_70.02",
																 "BR_70.03",
																 "BR_70.04",
																 "BR_70.05",
																 "BR_70.06",
																 "BR_70.07",
																 "BR_70.08",
																 "BR_70.09",
																 "BR_70.10",
																 "BR_70.11",
																 "BR_70.12",
																 "BR_70.13",
																 "BR_70.14",
																 "BR_70.15",
																 "BR_70.16",
																 "BR_70.17",
																 "BR_70.18",
																 "BR_70.19",
																 "BR_70.20",
																 "BR_70.21",
																 "BloodUnitInactivate.InactivateUnit",
																 "BloodUnitTest.ConfirmationWorklistUnitGUID"});
			this.lvBusinessRules.Location = new System.Drawing.Point(8, 24);
			this.lvBusinessRules.Name = "lvBusinessRules";
			this.lvBusinessRules.Size = new System.Drawing.Size(376, 186);
			this.lvBusinessRules.TabIndex = 0;
			this.lvBusinessRules.SelectedIndexChanged += new System.EventHandler(this.lvBusinessRules_SelectedIndexChanged_1);
			// 
			// btnRun
			// 
			this.btnRun.Enabled = false;
			this.btnRun.Location = new System.Drawing.Point(408, 224);
			this.btnRun.Name = "btnRun";
			this.btnRun.TabIndex = 2;
			this.btnRun.Text = "Run Tests";
			this.btnRun.Click += new System.EventHandler(this.btnRun_Click);
			// 
			// groupBox2
			// 
			this.groupBox2.Controls.Add(this.txtResults);
			this.groupBox2.Location = new System.Drawing.Point(488, 29);
			this.groupBox2.Name = "groupBox2";
			this.groupBox2.Size = new System.Drawing.Size(392, 467);
			this.groupBox2.TabIndex = 3;
			this.groupBox2.TabStop = false;
			this.groupBox2.Text = "Test Results";
			// 
			// txtResults
			// 
			this.txtResults.Location = new System.Drawing.Point(8, 24);
			this.txtResults.Multiline = true;
			this.txtResults.Name = "txtResults";
			this.txtResults.ReadOnly = true;
			this.txtResults.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
			this.txtResults.Size = new System.Drawing.Size(376, 432);
			this.txtResults.TabIndex = 1;
			this.txtResults.Text = "Select a test, then click \"Run Tests\". Results will appear here.";
			// 
			// btnClose
			// 
			this.btnClose.Location = new System.Drawing.Point(408, 320);
			this.btnClose.Name = "btnClose";
			this.btnClose.TabIndex = 4;
			this.btnClose.Text = "Close";
			this.btnClose.Click += new System.EventHandler(this.btnClose_Click);
			// 
			// specialTesting1
			// 
			this.specialTesting1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.specialTesting1.AntigensEnabled = true;
			this.specialTesting1.BloodUnitGuid = new System.Guid("00000000-0000-0000-0000-000000000000");
			this.specialTesting1.CmvEnabled = true;
			this.specialTesting1.CmvNegative = false;
			this.specialTesting1.DivisionCode = "";
			this.specialTesting1.IsDirty = false;
			this.specialTesting1.Location = new System.Drawing.Point(416, 48);
			this.specialTesting1.Name = "specialTesting1";
			this.specialTesting1.SickleCellEnabled = true;
			this.specialTesting1.SickleCellNegative = false;
			this.specialTesting1.Size = new System.Drawing.Size(56, 160);
			this.specialTesting1.TabIndex = 5;
			this.specialTesting1.Visible = false;
			// 
			// FrmEditUnitProcessingTestHarness
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(888, 534);
			this.Controls.Add(this.specialTesting1);
			this.Controls.Add(this.btnClose);
			this.Controls.Add(this.groupBox2);
			this.Controls.Add(this.btnRun);
			this.Controls.Add(this.groupBox1);
			this.Name = "FrmEditUnitProcessingTestHarness";
			this.RequiredFieldsLabel = true;
			this.Text = "VBECS - Edit Unit Information (Test Harness)";
			this.Controls.SetChildIndex(this.groupBox1, 0);
			this.Controls.SetChildIndex(this.btnRun, 0);
			this.Controls.SetChildIndex(this.groupBox2, 0);
			this.Controls.SetChildIndex(this.btnClose, 0);
			this.Controls.SetChildIndex(this.specialTesting1, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.groupBox1.ResumeLayout(false);
			this.groupBox2.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void lvBusinessRules_SelectedIndexChanged_1(object sender, System.EventArgs e)
		{
			switch (lvBusinessRules.SelectedItem.ToString())
			{
				case "BR_70.01":
					txtBusinessRule.Text = "Only unit antigen type results originally entered via UC_01 Process Incoming Shipment are available for inactivating when selecting the Edit Unit Information function. Unit antigen type results originally entered via UC_41 Record Phenotype Results must be inactivated by selecting the Inactivate Unit Testing function.";
					btnRun.Enabled = true;
					break;
				case "BR_70.02":
					txtBusinessRule.Text = "When editing the restricted for patient name for a blood unit, the actor may change the name of a restricted patient but may not allow the user to save the transaction without a new patient name for the restriction." + NEWLINE + NEWLINE + UI_MESSAGE;
					btnRun.Enabled = false;
					break;
				case "BR_70.03":
					txtBusinessRule.Text = "The system checks whether the blood unit is currently assigned to a patient. If so, the system displays a warning message: \"Unit currently assigned to a patient. You must release unit from the patient before proceeding. There is no override. The screen is cleared and a new unit can be selected." + NEWLINE + NEWLINE +
						"Test 1:" + NEWLINE + 
						"	ExpectedInput: A blood unit not assigned to a patient" + NEWLINE + 
						"	ExpectedOutput: None" + NEWLINE +
						"Test 2:" + NEWLINE + 
						"	ExpectedInput: A blood unit currently assigned to a paient" + NEWLINE + 
						"	ExpectedOutput: An error message";
					btnRun.Enabled = true;
					break;
				case "BR_70.04":
					txtBusinessRule.Text = "If the unit antigen typing test is selected, the system will display all antigen typing reagent types and interpretations performed at the users division for inactivation.";
					btnRun.Enabled = true;
					break;
				case "BR_70.05":
					txtBusinessRule.Text = "If the ABO/Rh confirmation test is selected, the system will display the unit confirmation test interpretations performed only at the users division for inactivation.";
					btnRun.Enabled = true;
					break;
				case "BR_70.06":
					txtBusinessRule.Text = "If the selected unit has a final unit status, the user cannot edit/inactivate any of the unit information. The system displays a warning message: \"Unit has been assigned a final status. Cannot edit/inactivate information. The screen is cleared and a new unit can be selected.";
					btnRun.Enabled = true;
					break;
				case "BR_70.07":
					txtBusinessRule.Text = "The system determines if the selected blood unit has a previous patient assignment record and displays a warning message if the actor security level is not a Traditional Supervisor, VBECS security level 4 or above: \"Unit has previous history of patient assignment. You cannot modify this unit. There is no override. The screen is cleared, allowing the actor to select a new unit.";
					btnRun.Enabled = true;
					break;
				case "BR_70.08":
					txtBusinessRule.Text = "The system allows changes to the following items associated with a unit, adding the new information to the unit, displaying only the latest entry for these fields to level 2 and above users before the unit has had any patient associations:" + NEWLINE +
											"	Restrictions" + NEWLINE +
											"	Special testing indicators, CMV negative and Sickle Cell negative" + NEWLINE +
											"	Biohazard indicator" + NEWLINE +
											"	Disease marker testing" + NEWLINE +
											"	Antigen typing entered at log-in (not performed at division)" + NEWLINE +
											"	Original volume" + NEWLINE +
											"	Discarded plasma volume, if one";
					btnRun.Enabled = true;
					break;
				case "BR_70.09":
					txtBusinessRule.Text = "When the unit log-in entry or a test result is marked as inactive, an audit trail report entry is generated.";
					btnRun.Enabled = true;
					break;
				case "BR_70.10":
					txtBusinessRule.Text = "When restricting a blood unit to a patient, the Patient ID is the primary identifier of the intended recipient. The VistA PATIENT File (#2) is searched for possible matches. If there is a match, the selected patient name populates the VBECS database. If the intended recipient is not yet entered in the VistA database, the Blood Bank Technologist is prompted to enter a patient name and ID. A unit restricted to a patient is not available for selection by any other patient. (This closely resembles BR_1.37.)";
					btnRun.Enabled = true;
					break;
				case "BR_70.11":
					txtBusinessRule.Text = "The user (level 4) may proceed to inactivate the unit with prior but no current patient associations. The system will require the entry of a comment (canned or free text) to explain the inactivation. The details of this change and comment create an audit trail report entry.";
					btnRun.Enabled = true;
					break;
				case "BR_70.12":
					txtBusinessRule.Text = "Workload previously associated with the inactivated test is not inactivated.";
					btnRun.Enabled = true;
					break;
				case "BR_70.13":
					txtBusinessRule.Text = "A unit record selected in this use case is not available to any other user for edit or update for the duration of this use case." + NEWLINE + NEWLINE + UI_MESSAGE;
					btnRun.Enabled = false;
					break;
				case "BR_70.14":
					txtBusinessRule.Text = "Editing of disease marker testing is restricted to autologous blood units. See PT_1.05 for donation codes." + NEWLINE + NEWLINE + UI_MESSAGE;
					btnRun.Enabled = false;
					break;
				case "BR_70.15":
					txtBusinessRule.Text = "Changes made to the blood unit are captured for inclusion in the audit report, including a change from null to a value. See PT_77.01 for details.";
					btnRun.Enabled = true;
					break;
				case "BR_70.16":
					txtBusinessRule.Text = "When editing the disease marker testing to POS or NFT, the biohazard indicator is automatically enabled." + NEWLINE + NEWLINE + UI_MESSAGE;
					btnRun.Enabled = false;
					break;
				case "BR_70.17":
					txtBusinessRule.Text = "When a blood unit is inactivated, all costs previously associated with that unit are also inactivated.";
					btnRun.Enabled = true;
					break;
				case "BR_70.18":
					txtBusinessRule.Text = "Inactivated units are clearly identified when generating shipment-associated reports such as in UC_75 Cost Accounting Report.";
					btnRun.Enabled = true;
					break;
				case "BR_70.19":
					txtBusinessRule.Text = "The system displays the following information for the selected unit:" + NEWLINE +
											"	Unit ID " + NEWLINE +
											"	Unit ABO/Rh " + NEWLINE +
											"	Unit product short name " + NEWLINE +
											"	Unit product code " + NEWLINE +
											"	Unit expiration date " + NEWLINE +
											"	Unit donation type" + NEWLINE +
											"	Patient restriction " + NEWLINE +
											"	Special testing indicator (CMV and sickle cell negative indicator)" + NEWLINE +
											"	Biohazard indicator " + NEWLINE +
											"	Disease marker testing " + NEWLINE +
											"	Antigen typing (entered as part of unit log-in)" + NEWLINE +
											"	Antigen typing (testing performed at division)" + NEWLINE +
											"	ABO/Rh confirmation testing interpretation" + NEWLINE +
											"	Original volume " + NEWLINE +
											"	Discarded plasma volume " + NEWLINE +
											"(Displays pooled unit information if the alternate flow stays in this use case)" + NEWLINE + NEWLINE + UI_MESSAGE;
					btnRun.Enabled = false;
					break;
				case "BR_70.20":
					txtBusinessRule.Text = "The user may add unit information (as done in UC_01 via check box), sickle cell negative, CMV negative, and antigen typing to a unit at any time from a setting of null only." + NEWLINE + NEWLINE + UI_MESSAGE;
					btnRun.Enabled = false;
					break;
				case "BR_70.21":
					txtBusinessRule.Text = "The system will check if the selected blood unit has active ABO/Rh Confirmation or Antigen Typings associated with it. If the unit does have associated active tests, the system does not allow the user to inactivate the unit and displays a warning message to the user, Unit has active tests that must be inactivated before the unit can be inactivated. There is no override.";
					btnRun.Enabled = true;
					break;
				case "BloodUnitInactivate.InactivateUnit":
					txtBusinessRule.Text = "Test the InactivateUnit method of the BloodUnitInactivate class." + NEWLINE +
						"<summary>" + NEWLINE + 
						"	Inactivates a blood unit" + NEWLINE + 
						"	Implements BR_70.06, BR_70.07, BR_70.09, BR_70.11, BR_70.17, BR_70.18, BR_70.21" + NEWLINE + 
						"</summary>" + NEWLINE + 
						"<param name=\"bloodUnit\">The blood unit to be inactivated</param>" + NEWLINE + 
						"<param name=\"inactivateCommentText\">A comment required to inactivate a unit</param>" + NEWLINE + 
						"<param name=\"lastUpdateFunctionId\">UC or function performing this call</param>" + NEWLINE + 
						"<returns>A boolean indicating whether a save succeeded or failed</returns>" + NEWLINE + NEWLINE +
						"<Case type=\"0\"> " + NEWLINE + 
						"	<ExpectedInput>Valid blood unit, inactivation comment and last update function ID</ExpectedInput>" + NEWLINE + 
						"	<ExpectedOutput>None</ExpectedOutput>" + NEWLINE + 
						"</Case>" + NEWLINE + 
						"<Case type=\"1\"> " + NEWLINE + 
						"	<ExpectedInput>Invalid blood unit</ExpectedInput>" + NEWLINE + 
						"	<ExpectedOutput>Business Object Exception thrown</ExpectedOutput>" + NEWLINE + 
						"</Case>" + NEWLINE;
					btnRun.Enabled = false;
					break;
				case "BloodUnitTest.ConfirmationWorklistUnitGUID":
					txtBusinessRule.Text = "Test the ConfirmationWorklistUnitGUID property of the BloodUnitTest class." + NEWLINE + 
						"<summary>" + NEWLINE + 
						"Gets or sets the confirmation worklist unit GUID of the blood unit test object" + NEWLINE + 
						"</summary>" + NEWLINE + 
						"<Case type=\"0\"> " + NEWLINE + 
						"	<ExpectedInput>A valid argument (a System.Guid type argument)</ExpectedInput>" + NEWLINE + 
						"	<ExpectedOutput>None</ExpectedOutput>" + NEWLINE + 
						"</Case>" + NEWLINE + 
						"<Case type=\"1\"> " + NEWLINE + 
						"	<ExpectedInput>An invalid argument (an empty System.GUID)</ExpectedInput>" + NEWLINE + 
						"	<ExpectedOutput>Argument Null Exception thrown</ExpectedOutput>" + NEWLINE + 
						"</Case>" + NEWLINE;
					btnRun.Enabled = false;
					break;
				default:
					btnRun.Enabled = false;
					break;
			}
		}

		private void btnClose_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void btnRun_Click(object sender, System.EventArgs e)
		{
			btnRun.Enabled = false;
			txtResults.Text = "";
			this.Refresh();
			switch (lvBusinessRules.SelectedItem.ToString())
			{
				case "BR_70.01":
					Test01();
					break;
				case "BR_70.03":
					Test03();
					break;
				case "BR_70.04":
					Test04();
					break;
				case "BR_70.05":
					Test05();
					break;
				case "BR_70.06":
					Test06();
					break;
				case "BR_70.07":
					Test07();    
					break;
				case "BR_70.08":
					Test08();    
					break;
				case "BR_70.09":
					Test09();    
					break;
				case "BR_70.10":
					Test10();    
					break;
				case "BR_70.11":
					Test11();    
					break;
				case "BR_70.12":
					Test12();    
					break;
				case "BR_70.15":
					Test15();    
					break;
				case "BR_70.17":
					Test17();    
					break;
				case "BR_70.18":
					Test18();    
					break;
				case "BR_70.21":
					Test21();    
					break;
				case "BloodUnitInactivate.InactivateUnit":
					TestBloodUnitInactivate();
					break;
				case "BloodUnitTest.ConfirmationWorklistUnitGUID":
					TestConfirmationWorklistUnitGUID();
					break;
				default:
					btnRun.Enabled = false;
					break;
			}
			btnRun.Enabled = true;
			lvBusinessRules.Focus();
		}

		private BOL.BloodUnit InitializeTest(System.Guid bloodUnitGUID, string bussinessRule)
		{
			try
			{
				this.Refresh();
				BOL.BloodUnit bloodUnit = new BOL.BloodUnit(bloodUnitGUID);
				//Perform necessasry tests
				txtResults.Text = txtResults.Text + "Testing " + bussinessRule + " with blood unit ID " + bloodUnit.EyeReadableUnitId + ", product " + bloodUnit.ProductShortName + NEWLINE + NEWLINE;
				this.Refresh();
				return bloodUnit;
			}
			catch (Exception ex)
			{
				throw(ex);
			}
		}

		private void ReActivateUnit(System.Guid bloodUnitGUID)
		{
			try
			{
				SqlConnection conn = new SqlConnection( VbecsConfig.Current.PrimaryDbConnectionString );
				conn.Open();
				SqlCommand cmd1 = new SqlCommand("UPDATE BloodUnit SET RecordStatusCode = 'A' where BloodUnitGuid = '" + bloodUnitGUID + "'", conn);
				SqlCommand cmd2 = new SqlCommand("UPDATE BloodUnitMedia SET Comments = null where BloodUnitGuid = '" + bloodUnitGUID + "'", conn);
				SqlCommand cmd3 = new SqlCommand("UPDATE BloodUnitAntigen SET RecordStatusCode = 'A' where BloodUnitGuid = '" + bloodUnitGUID + "'", conn);
				int retVal;
				retVal = cmd1.ExecuteNonQuery();
				retVal = cmd2.ExecuteNonQuery();
				retVal = cmd3.ExecuteNonQuery();
				conn.Close();
				conn.Dispose();
			}
			catch (Exception ex)
			{
				throw(ex);
			}
		}

		private void ReActivateTests(System.Guid bloodUnitGUID)
		{
			try
			{
				SqlConnection conn = new SqlConnection(Common.VbecsConfig.Current.PrimaryDbConnectionString);
				conn.Open();
				SqlCommand cmd1 = new SqlCommand("UPDATE BloodUnitTest SET RecordStatusCode = 'A', TestComments = '' where BloodUnitGuid = '" + bloodUnitGUID + "'", conn);
				int retVal = cmd1.ExecuteNonQuery();
				conn.Close();
				conn.Dispose();
			}
			catch (Exception ex)
			{
				throw(ex);
			}
		}

		private void Test01()
		{
			try
			{
				txtResults.Text = "";
				//Select a blood unit appropriate for testing the business rule
				BOL.BloodUnit bloodUnit = InitializeTest(new System.Guid("5FBEEDF4-B604-4BE3-A684-9C419D8AAF74"), "BR_70.01");
				txtResults.Text = txtResults.Text + "Loading blood unit antigens." + NEWLINE;
				this.specialTesting1.LoadAntigenList();
				this.specialTesting1.DivisionCode = Common.LogonUser.LogonUserDivisionCode;
				this.specialTesting1.BloodUnitGuid = bloodUnit.BloodUnitGuid;
				txtResults.Text = txtResults.Text + "Successfully loaded " + this.specialTesting1.SelectedAntigens.Length.ToString() + " antigen type results." + NEWLINE;
				txtResults.Text = txtResults.Text + "Example antigen: " + this.specialTesting1.SelectedAntigens[0].ToString() + "" + NEWLINE;
				this.specialTesting1.ResetSpecialTesting();
				txtResults.Text = txtResults.Text + NEWLINE + "Test completed successfully.";
			}
			catch (Exception ex)
			{
				txtResults.Text = txtResults.Text + NEWLINE + "Test FAILED! The following error occurred:" + NEWLINE + ex.Message;
			}
		}

		private void Test03()
		{
			int currentTest = 1;
			try
			{
				txtResults.Text = "";
				BOL.BloodUnit bloodUnitFail = InitializeTest(new System.Guid("4541E832-3D5B-48C6-A504-FF646DC8EF14"), "BR_70.03");
				DataTable dtFail = BOL.OrderedUnit.GetOrderedUnit(bloodUnitFail.BloodUnitGuid, Common.LogonUser.LogonUserDivisionCode);
				if (dtFail.Rows.Count > 0)
				{
					txtResults.Text = txtResults.Text + "Unit currently assigned to a patient. You must release unit from the patient before proceeding." + NEWLINE;
					txtResults.Text = txtResults.Text + NEWLINE + "Test " + currentTest.ToString() + " status: Fail." + NEWLINE + NEWLINE;
				}
				else
				{
					txtResults.Text = txtResults.Text + "Blood unit is currently not assigned to a patient." + NEWLINE;
					txtResults.Text = txtResults.Text + NEWLINE + "Test " + currentTest.ToString() + " status: Pass." + NEWLINE + NEWLINE;
				}
				currentTest++;
				//Select a blood unit appropriate for testing the business rule
				BOL.BloodUnit bloodUnitPass = InitializeTest(new System.Guid("12037FA7-8EC9-4956-B0E8-AE3BF3D14594"), "BR_70.03");
				DataTable dtPass = BOL.OrderedUnit.GetOrderedUnit(bloodUnitPass.BloodUnitGuid, Common.LogonUser.LogonUserDivisionCode);
				if (dtPass.Rows.Count > 0)
				{
					txtResults.Text = txtResults.Text + "Unit currently assigned to a patient. You must release unit from the patient before proceeding." + NEWLINE;
					txtResults.Text = txtResults.Text + NEWLINE + "Test " + currentTest.ToString() + " status: Pass.";
				}
				else
				{
					txtResults.Text = txtResults.Text + "Blood unit is currently not assigned to a patient." + NEWLINE;
					txtResults.Text = txtResults.Text + NEWLINE + "Test " + currentTest.ToString() + " status: Fail.";
				}
			}
			catch (Exception ex)
			{
				txtResults.Text = txtResults.Text + NEWLINE + "Test " + currentTest.ToString() + " status: Fail! The following error occurred:" + NEWLINE + ex.Message;
			}
		}

		private void Test04()
		{
			try
			{
				txtResults.Text = "";
				//Select a blood unit appropriate for testing the business rule
				BOL.BloodUnit bloodUnit = InitializeTest(new System.Guid("47E30D97-CA42-4563-A9FF-BE6E1832CD53"), "BR_70.04");
				ArrayList alAntigenTypingTests = BOL.BloodUnitTest.GetAntigenTypingTests(bloodUnit.BloodUnitGuid, Common.LogonUser.LogonUserDivisionCode);
				txtResults.Text = txtResults.Text + "Unit has " + alAntigenTypingTests.Count + " individual antigen typing test results." + NEWLINE;

				foreach (Object obj in alAntigenTypingTests)
				{
					BOL.BloodUnitTest buTest = (BOL.BloodUnitTest) obj;

					txtResults.Text = txtResults.Text + "Example test: Date=" + buTest.TestDate + ", Result=" + buTest.TestResultId + NEWLINE;
					txtResults.Text = txtResults.Text + NEWLINE + "Test completed successfully.";
				}
			}
			catch (Exception ex)
			{
				txtResults.Text = txtResults.Text + NEWLINE + "Test FAILED! The following error occurred:" + NEWLINE + ex.Message;
			}
		}

		private void Test05()
		{
			try
			{
				txtResults.Text = "";
				//Select a blood unit appropriate for testing the business rule
				BOL.BloodUnit bloodUnit = InitializeTest(new System.Guid("072F3F6D-EC2C-479A-A495-60C489767D92"), "BR_70.05");
				ArrayList alAboRhConfirmationTests = BOL.BloodUnitTest.GetAboRHConfirmationTests(bloodUnit.BloodUnitGuid, Common.LogonUser.LogonUserDivisionCode);
				txtResults.Text = txtResults.Text + "Unit has " + alAboRhConfirmationTests.Count + " individual Abo/Rh confirmation test results." + NEWLINE;
				
				foreach (Object obj in alAboRhConfirmationTests)
				{
					BOL.BloodUnitTest buTest = (BOL.BloodUnitTest) obj;
				
					txtResults.Text = txtResults.Text + "Example test: Date=" + buTest.TestDate + ", Result=" + buTest.TestResultId + NEWLINE;
					txtResults.Text = txtResults.Text + NEWLINE + "Test completed successfully.";
				}
			}
			catch (Exception ex)
			{
				txtResults.Text = txtResults.Text + NEWLINE + "Test FAILED! The following error occurred:" + NEWLINE + ex.Message;
			}
		}

		private void Test06()
		{
			try
			{
				txtResults.Text = "";
				//Select a blood unit appropriate for testing the business rule
//				BOL.BloodUnit bloodUnitPass = InitializeTest(new System.Guid("5FBEEDF4-B604-4BE3-A684-9C419D8AAF74"), "BR_70.06");
//				if (bloodUnitPass.BloodUnitStatus.IsFinal())
//				{
//					txtResults.Text = txtResults.Text + "Blood Unit is in final status. Actual status - " + bloodUnitPass.BloodUnitStatus.UnitStatusText + NEWLINE + NEWLINE;
//				}
//				else
//				{
//					txtResults.Text = txtResults.Text + "Blood Unit is not in final status. Actual status - " + bloodUnitPass.BloodUnitStatus.UnitStatusText + NEWLINE + NEWLINE;
//				}
				BOL.BloodUnit bloodUnitFail = InitializeTest(new System.Guid("50035713-D7C7-4016-B722-99B658A529CF"), "BR_70.06");
				if (bloodUnitFail.BloodUnitStatus.IsFinal())
				{
					txtResults.Text = txtResults.Text + "Unit has been assigned a final status. Cannot edit/inactivate information." + NEWLINE;
				}
				else
				{
					txtResults.Text = txtResults.Text + "Blood Unit is not in final status. Actual status - " + bloodUnitFail.BloodUnitStatus.UnitStatusText + "." + NEWLINE;
				}
				txtResults.Text = txtResults.Text + NEWLINE + "Test completed successfully.";
			}
			catch (Exception ex)
			{
				txtResults.Text = txtResults.Text + NEWLINE + "Test FAILED! The following error occurred:" + NEWLINE + ex.Message;
			}
		}

		private void Test07()
		{
			try
			{
				txtResults.Text = "";
				//Select a blood unit appropriate for testing the business rule
				BOL.BloodUnit bloodUnitPass = InitializeTest(new System.Guid("039411C8-F4B6-4374-A863-938F8F036F37"), "BR_70.07");
				txtResults.Text = txtResults.Text + "Temporarily changing VBECS user security level to 2 - Enhanced Technologist." + NEWLINE;
				DataTable orderedUnitsPass = BOL.OrderedUnit.GetHistoricalOrderedUnits(bloodUnitPass.BloodUnitGuid, Common.LogonUser.LogonUserDivisionCode);
				if (orderedUnitsPass.Rows.Count > 0)
				{
					txtResults.Text = txtResults.Text + "Unit has previous history of patient assignment. You cannot modify this unit." + NEWLINE;
				}
				else
				{
					txtResults.Text = txtResults.Text + "Blood unit has no previous history of patient assignment." + NEWLINE;
				}
//				BOL.BloodUnit bloodUnitFail = InitializeTest(new System.Guid("5FBEEDF4-B604-4BE3-A684-9C419D8AAF74"), "BR_70.07");
//				DataTable orderedUnitsFail = BOL.OrderedUnit.GetHistoricalOrderedUnits(bloodUnitFail.BloodUnitGuid, Common.LogonUser.LogonUserDivisionCode);
//				if (orderedUnitsFail.Rows.Count > 0)
//				{
//					txtResults.Text = txtResults.Text + "Unit has previous history of patient assignment. You cannot modify this unit." + NEWLINE;
//				}
//				else
//				{
//					txtResults.Text = txtResults.Text + "Blood unit has no previous history of patient assignment." + NEWLINE;
//				}
				txtResults.Text = txtResults.Text + NEWLINE + "Test completed successfully.";
			}
			catch (Exception ex)
			{
				txtResults.Text = txtResults.Text + NEWLINE + "Test FAILED! The following error occurred:" + NEWLINE + ex.Message;
			}
		}

		private void Test08()
		{
			try
			{
				txtResults.Text = "";
				//Select a blood unit appropriate for testing the business rule
				BOL.BloodUnit bloodUnit = InitializeTest(new System.Guid("5FBEEDF4-B604-4BE3-A684-9C419D8AAF74"), "BR_70.08");
				txtResults.Text = txtResults.Text + "Attempting to save unit." + NEWLINE;
				bloodUnit.IsDirty = true;
				bloodUnit.LastUpdateUser = ThisUser.UserNTLoginID;
				bloodUnit.LastUpdateDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
				bloodUnit.BloodUnitMedia.IsDirty = true;
				bloodUnit.BloodUnitStatus.IsDirty = true;
				bool retval = bloodUnit.Save(true, false, false, new ArrayList(), new ArrayList(), Common.UpdateFunction.UC070FrmEditUnitProcessingTestHarness);
				txtResults.Text = txtResults.Text + NEWLINE + "Test completed successfully.";
			}
			catch (Exception ex)
			{
				txtResults.Text = txtResults.Text + NEWLINE + "Test FAILED! The following error occurred:" + NEWLINE + ex.Message;
			}
		}

		private void Test09()
		{
			try
			{
				txtResults.Text = "";
				//Select a blood unit appropriate for testing the business rule
				BOL.BloodUnit bloodUnit = InitializeTest(new System.Guid("5FBEEDF4-B604-4BE3-A684-9C419D8AAF74"), "BR_70.09");
				DataTable antigens=BOL.BloodUnitAntigen.GetBloodUnitAntigens(bloodUnit.BloodUnitGuid, bloodUnit.DivisionCode);
				ArrayList list=new ArrayList();
				foreach(DataRow obj in antigens.Rows)
				{
					list.Add(new BOL.BloodUnitAntigen(obj));
				}
				Common.WorkloadProcessID workloadProcessID = Common.WorkloadProcessID.Unknown;
				BOL.BloodUnitInactivate.InactivateUnit(bloodUnit, "This is a test of inactivation", Common.UpdateFunction.UnitTests,list, ref workloadProcessID);
				txtResults.Text = txtResults.Text + NEWLINE + "Test completed successfully.";
				//Here, re-activate unit
				ReActivateUnit(bloodUnit.BloodUnitGuid);
			}
			catch (Exception ex)
			{
				txtResults.Text = txtResults.Text + NEWLINE + "Test FAILED! The following error occurred:" + NEWLINE + ex.Message;
			}
		}

		private void Test10()
		{
			try
			{
				txtResults.Text = "";
				//Select a blood unit appropriate for testing the business rule
				BOL.BloodUnit bloodUnit = InitializeTest(new System.Guid("5FBEEDF4-B604-4BE3-A684-9C419D8AAF74"), "BR_70.10");
				bloodUnit.LastUpdateUser = ThisUser.UserNTLoginID;
				bloodUnit.LastUpdateDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
				bool retval = bloodUnit.Save(true, false, false, new ArrayList(), new ArrayList(), Common.UpdateFunction.UC070FrmEditUnitProcessingTestHarness);
				txtResults.Text = txtResults.Text + NEWLINE + "Test completed successfully.";
			}
			catch (Exception ex)
			{
				txtResults.Text = txtResults.Text + NEWLINE + "Test FAILED! The following error occurred:" + NEWLINE + ex.Message;
			}
		}

		private void Test11()
		{
			try
			{
				txtResults.Text = "";
				//Select a blood unit appropriate for testing the business rule
				BOL.BloodUnit bloodUnitFailAssoc = InitializeTest(new System.Guid("12037FA7-8EC9-4956-B0E8-AE3BF3D14594"), "BR_70.11");
				txtResults.Text = txtResults.Text + "Testing inactivating a unit with current patient associations." + NEWLINE;
				
				DataTable antigens=BOL.BloodUnitAntigen.GetBloodUnitAntigens(bloodUnitFailAssoc.BloodUnitGuid, bloodUnitFailAssoc.DivisionCode);
				ArrayList list=new ArrayList();
				foreach(DataRow obj in antigens.Rows)
				{
					list.Add(new BOL.BloodUnitAntigen(obj));
				}
				try
				{
					Common.WorkloadProcessID workloadProcessID = Common.WorkloadProcessID.Unknown;
					BOL.BloodUnitInactivate.InactivateUnit(bloodUnitFailAssoc, "This is a test of inactivation of a unit with current patient associations", Common.UpdateFunction.UnitTests,list, ref workloadProcessID);
				}
				catch (BOL.BusinessObjectException ex)
				{
					txtResults.Text = txtResults.Text + ex.Message + "" + NEWLINE;
				}
				BOL.BloodUnit bloodUnitFailComment = InitializeTest(new System.Guid("5FBEEDF4-B604-4BE3-A684-9C419D8AAF74"), "BR_70.11");
				txtResults.Text = txtResults.Text + "Testing inactivating a unit without an inactivation comment." + NEWLINE;
				
				antigens=BOL.BloodUnitAntigen.GetBloodUnitAntigens(bloodUnitFailComment.BloodUnitGuid, bloodUnitFailComment.DivisionCode);
				list=new ArrayList();
				foreach(DataRow obj in antigens.Rows)
				{
					list.Add(new BOL.BloodUnitAntigen(obj));
				}
				try
				{
					Common.WorkloadProcessID workloadProcessID = Common.WorkloadProcessID.Unknown;
					BOL.BloodUnitInactivate.InactivateUnit(bloodUnitFailComment, "", Common.UpdateFunction.UnitTests,list, ref workloadProcessID);
				}
				catch (BOL.BusinessObjectException ex)
				{
					txtResults.Text = txtResults.Text + ex.Message + "" + NEWLINE;
				}
				txtResults.Text = txtResults.Text + NEWLINE + "Test completed successfully.";
			}
			catch (Exception ex)
			{
				txtResults.Text = txtResults.Text + NEWLINE + "Test FAILED! The following error occurred:" + NEWLINE + ex.Message;
			}
		}

		private void Test12()
		{
			try
			{
				txtResults.Text = "";
				//Select a blood unit appropriate for testing the business rule
				BOL.BloodUnit bloodUnitAT = InitializeTest(new System.Guid("47E30D97-CA42-4563-A9FF-BE6E1832CD53"), "BR_70.12");
				//First, inactivate Antigen Typing test results
				ArrayList alAntigenTypingTestsPre = BOL.BloodUnitTest.GetAntigenTypingTests(bloodUnitAT.BloodUnitGuid, Common.LogonUser.LogonUserDivisionCode);
				txtResults.Text = txtResults.Text + "Unit has " + alAntigenTypingTestsPre.Count + " individual antigen typing test results prior to test result inactivation." + NEWLINE;
				
				// Added 12/6/2004
				ArrayList templist=new ArrayList();
				foreach (Object obj in alAntigenTypingTestsPre)
				{
					BOL.BloodUnitTest buTest = (BOL.BloodUnitTest) obj;
				
					// Added 12/6/2004 RDH
					templist.Add(buTest);
					
					txtResults.Text = txtResults.Text + "Attempting to inactivate some test results." + NEWLINE;
					
					BOL.BloodUnitTest.InactivateAntigenTypingTests(bloodUnitAT.BloodUnitGuid, buTest.AntiseraWorklistTypingGuid, "Testing antigen typing inactivation", Common.UpdateFunction.UnitTests, Common.WorkloadProcessID.AntigenPhenotypingMultipleTestPhasesQC, alAntigenTypingTestsPre, Common.TestingMethod.Tube.ToString());
				
					// Added 12/6/2004 RDH
					templist.Clear();
				}
				
				ArrayList alAntigenTypingTestsPost = BOL.BloodUnitTest.GetAntigenTypingTests(bloodUnitAT.BloodUnitGuid, Common.LogonUser.LogonUserDivisionCode);
				txtResults.Text = txtResults.Text + "Unit has " + alAntigenTypingTestsPost.Count + " individual antigen typing test results after test result inactivation." + NEWLINE + NEWLINE;
				//Next, inactivate Abo/Rh Confirmation test results
				BOL.BloodUnit bloodUnitAC = InitializeTest(new System.Guid("072F3F6D-EC2C-479A-A495-60C489767D92"), "BR_70.12");
				ArrayList alAboRhConfirmationTestsPre = BOL.BloodUnitTest.GetAboRHConfirmationTests(bloodUnitAC.BloodUnitGuid, Common.LogonUser.LogonUserDivisionCode);
				txtResults.Text = txtResults.Text + "Unit has " + alAboRhConfirmationTestsPre.Count + " individual Abo/Rh confirmation test results prior to test result inactivation." + NEWLINE;
	
				
				templist=new ArrayList();
				
				//For loop is unnecessary. Make one single call to the 
				//BOL passing in alABORhConfirmationTestsPre
				foreach (Object obj in alAboRhConfirmationTestsPre)
				{
					BOL.BloodUnitTest buTest = (BOL.BloodUnitTest) obj;

					// Added 12/6/2004 RDH
					// Temporary arraylist to hold bloodunittest objects to be
					// passed to the DAL.
					templist.Add(buTest);

					txtResults.Text = txtResults.Text + "Attempting to inactivate some test results." + NEWLINE;
					
					// BR_70.25 : if all tests have been selected to be invalidated, we need to return status to limited
					bool allTestsInactivated = ( alAntigenTypingTestsPre.Count == templist.Count );
					//

					BOL.BloodUnitTest.InactivateAboRHConfirmationTests( bloodUnitAC, buTest.ConfirmationWorklistUnitGuid, "Testing Abo/Rh confirmation inactivation", Common.UpdateFunction.UnitTests, templist, allTestsInactivated , Common.TestingMethod.Tube.ToString(),true);

					// Added 12/6/2004 RDH
					templist.Clear();

				}
				
				ArrayList alAboRhConfirmationTestsPost = BOL.BloodUnitTest.GetAboRHConfirmationTests(bloodUnitAC.BloodUnitGuid, Common.LogonUser.LogonUserDivisionCode);
				txtResults.Text = txtResults.Text + "Unit has " + alAboRhConfirmationTestsPost.Count + " individual Abo/Rh confirmation test results after test result inactivation." + NEWLINE;
				txtResults.Text = txtResults.Text + NEWLINE + "Test completed successfully.";
				//Here, re-activate test
				ReActivateTests(bloodUnitAT.BloodUnitGuid);
				ReActivateTests(bloodUnitAC.BloodUnitGuid);
			}
			catch (Exception ex)
			{
				txtResults.Text = txtResults.Text + NEWLINE + "Test FAILED! The following error occurred:" + NEWLINE + ex.Message;
			}
		}

		private void Test15()
		{
			try
			{
				txtResults.Text = "";
				//Select a blood unit appropriate for testing the business rule
				BOL.BloodUnit bloodUnit = InitializeTest(new System.Guid("5FBEEDF4-B604-4BE3-A684-9C419D8AAF74"), "BR_70.15");
				bloodUnit.LastUpdateUser = ThisUser.UserNTLoginID;
				bloodUnit.LastUpdateDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
				bool retval = bloodUnit.Save(true, false, false, new ArrayList(), new ArrayList(), Common.UpdateFunction.UC070FrmEditUnitProcessingTestHarness);
				txtResults.Text = txtResults.Text + NEWLINE + "Test completed successfully.";
			}
			catch (Exception ex)
			{
				txtResults.Text = txtResults.Text + NEWLINE + "Test FAILED! The following error occurred:" + NEWLINE + ex.Message;
			}
		}

		private void Test17()
		{
			try
			{
				txtResults.Text = "";
				//Select a blood unit appropriate for testing the business rule
				BOL.BloodUnit bloodUnit = InitializeTest(new System.Guid("5FBEEDF4-B604-4BE3-A684-9C419D8AAF74"), "BR_70.17");
				DataTable antigens=BOL.BloodUnitAntigen.GetBloodUnitAntigens(bloodUnit.BloodUnitGuid, bloodUnit.DivisionCode);
				ArrayList list=new ArrayList();
				foreach(DataRow obj in antigens.Rows)
				{
					list.Add(new BOL.BloodUnitAntigen(obj));
				}
				Common.WorkloadProcessID workloadProcessID = Common.WorkloadProcessID.Unknown;
				BOL.BloodUnitInactivate.InactivateUnit(bloodUnit, "This is a test of inactivation of a unit and its associated costs", Common.UpdateFunction.UnitTests, list, ref workloadProcessID);
				txtResults.Text = txtResults.Text + NEWLINE + "Test completed successfully.";
				//Here, re-activate unit
				ReActivateUnit(bloodUnit.BloodUnitGuid);
			}
			catch (Exception ex)
			{
				txtResults.Text = txtResults.Text + NEWLINE + "Test FAILED! The following error occurred:" + NEWLINE + ex.Message;
			}
		}

		private void Test18()
		{
			try
			{
				txtResults.Text = "";
				//Select a blood unit appropriate for testing the business rule
				BOL.BloodUnit bloodUnit = InitializeTest(new System.Guid("5FBEEDF4-B604-4BE3-A684-9C419D8AAF74"), "BR_70.17");
				DataTable antigens=BOL.BloodUnitAntigen.GetBloodUnitAntigens(bloodUnit.BloodUnitGuid, bloodUnit.DivisionCode);
				ArrayList list=new ArrayList();
				foreach(DataRow obj in antigens.Rows)
				{
					list.Add(new BOL.BloodUnitAntigen(obj));
				}
				Common.WorkloadProcessID workloadProcessID = Common.WorkloadProcessID.Unknown;
				BOL.BloodUnitInactivate.InactivateUnit(bloodUnit, "This is a test of inactivation of a unit", Common.UpdateFunction.UnitTests,list, ref workloadProcessID);
				txtResults.Text = txtResults.Text + NEWLINE + "Test completed successfully.";
				//Here, re-activate unit
				ReActivateUnit(bloodUnit.BloodUnitGuid);
			}
			catch (Exception ex)
			{
				txtResults.Text = txtResults.Text + NEWLINE + "Test FAILED! The following error occurred:" + NEWLINE + ex.Message;
			}
		}

		private void Test21()
		{
			try
			{
				txtResults.Text = "";
				//Select a blood unit appropriate for testing the business rule
				BOL.BloodUnit bloodUnitAboRh = InitializeTest(new System.Guid("072F3F6D-EC2C-479A-A495-60C489767D92"), "BR_70.21");
				ArrayList alAboRhConfirmationTests = BOL.BloodUnitTest.GetAboRHConfirmationTests(bloodUnitAboRh.BloodUnitGuid, Common.LogonUser.LogonUserDivisionCode);
				txtResults.Text = txtResults.Text + "Unit has " + alAboRhConfirmationTests.Count + " individual Abo/Rh confirmation test results." + NEWLINE;				
				
				DataTable antigens=BOL.BloodUnitAntigen.GetBloodUnitAntigens(bloodUnitAboRh.BloodUnitGuid, bloodUnitAboRh.DivisionCode);
				ArrayList list=new ArrayList();
				foreach(DataRow obj in antigens.Rows)
				{
					list.Add(new BOL.BloodUnitAntigen(obj));
				}
				try
				{
					Common.WorkloadProcessID workloadProcessID = Common.WorkloadProcessID.Unknown;
					BOL.BloodUnitInactivate.InactivateUnit(bloodUnitAboRh, "Testing inactivation of a blood unit with Abo/Rh confirmation tests.", Common.UpdateFunction.UnitTests,list, ref workloadProcessID);
					txtResults.Text = txtResults.Text + "Blood Unit inactivated successfully." + NEWLINE + NEWLINE;
				}
				catch (Exception ex)
				{
					txtResults.Text = txtResults.Text + "Inactivation failed: " + ex.Message + NEWLINE + NEWLINE;
					ex = null;
				}
				BOL.BloodUnit bloodUnitAntigenType = InitializeTest(new System.Guid("47E30D97-CA42-4563-A9FF-BE6E1832CD53"), "BR_70.21");
				ArrayList alAntigenTypingTests = BOL.BloodUnitTest.GetAntigenTypingTests(bloodUnitAntigenType.BloodUnitGuid, Common.LogonUser.LogonUserDivisionCode);
				txtResults.Text = txtResults.Text + "Unit has " + alAntigenTypingTests.Count + " individual antigen typing test results." + NEWLINE;
				
				antigens=BOL.BloodUnitAntigen.GetBloodUnitAntigens(bloodUnitAntigenType.BloodUnitGuid, bloodUnitAntigenType.DivisionCode);
				list=new ArrayList();
				foreach(DataRow obj in antigens.Rows)
				{
					list.Add(new BOL.BloodUnitAntigen(obj));
				}
				try
				{
					Common.WorkloadProcessID workloadProcessID = Common.WorkloadProcessID.Unknown;
					BOL.BloodUnitInactivate.InactivateUnit(bloodUnitAntigenType, "Testing inactivation of a blood unit with antigen typing tests.", Common.UpdateFunction.UnitTests,list, ref workloadProcessID);
					txtResults.Text = txtResults.Text + "Blood Unit inactivated successfully." + NEWLINE;
				}
				catch (Exception ex)
				{
					txtResults.Text = txtResults.Text + "Inactivation failed: " + ex.Message + "" + NEWLINE;
					ex = null;
				}
				txtResults.Text = txtResults.Text + NEWLINE + "Test completed successfully.";
			}
			catch (Exception ex)
			{
				txtResults.Text = txtResults.Text + NEWLINE + "Test FAILED! The following error occurred:" + NEWLINE + ex.Message;
			}
		}

		private void TestBloodUnitInactivate()
		{
			try
			{
				txtResults.Text = "";
				//Select a blood unit appropriate for testing the business rule
				BOL.BloodUnit bloodUnitPass = InitializeTest(new System.Guid("5FBEEDF4-B604-4BE3-A684-9C419D8AAF74"), "BloodUnitInactivate.InactivateUnit");
				
				DataTable antigens=BOL.BloodUnitAntigen.GetBloodUnitAntigens(bloodUnitPass.BloodUnitGuid, bloodUnitPass.DivisionCode);
				ArrayList list=new ArrayList();
				foreach(DataRow obj in antigens.Rows)
				{
					list.Add(new BOL.BloodUnitAntigen(obj));
				}

				try
				{
					Common.WorkloadProcessID workloadProcessID = Common.WorkloadProcessID.Unknown;
					BOL.BloodUnitInactivate.InactivateUnit(bloodUnitPass, "Testing inactivation of a blood unit.", Common.UpdateFunction.UnitTests, list, ref workloadProcessID);
					txtResults.Text = txtResults.Text + "Blood Unit inactivated successfully." + NEWLINE + NEWLINE;
				}
				catch (Exception ex)
				{
					txtResults.Text = txtResults.Text + "Inactivation failed: " + ex.Message + NEWLINE + NEWLINE;
					ex = null;
				}
				BOL.BloodUnit bloodUnitFail = InitializeTest(new System.Guid("072F3F6D-EC2C-479A-A495-60C489767D92"), "BloodUnitInactivate.InactivateUnit");
				
				antigens=BOL.BloodUnitAntigen.GetBloodUnitAntigens(bloodUnitFail.BloodUnitGuid, bloodUnitFail.DivisionCode);
				list=new ArrayList();
				foreach(DataRow obj in antigens.Rows)
				{
					list.Add(new BOL.BloodUnitAntigen(obj));
				}
				try
				{
					Common.WorkloadProcessID workloadProcessID = Common.WorkloadProcessID.Unknown;
					BOL.BloodUnitInactivate.InactivateUnit(bloodUnitFail, "Testing inactivation of a blood unit with Abo/Rh confirmation tests.", Common.UpdateFunction.UnitTests,list, ref workloadProcessID);
					txtResults.Text = txtResults.Text + "Blood Unit inactivated successfully." + NEWLINE;
				}
				catch (Exception ex)
				{
					txtResults.Text = txtResults.Text + "Inactivation failed: " + ex.Message + NEWLINE;
					ex = null;
				}
				txtResults.Text = txtResults.Text + NEWLINE + "Test completed successfully.";
				//Here, re-activate unit
				ReActivateUnit(bloodUnitFail.BloodUnitGuid);
				ReActivateUnit(bloodUnitPass.BloodUnitGuid);
			}
			catch (Exception ex)
			{
				txtResults.Text = txtResults.Text + NEWLINE + "Test FAILED! The following error occurred:" + NEWLINE + ex.Message;
			}
		}
		private void TestConfirmationWorklistUnitGUID()
		{
			try
			{
				txtResults.Text = txtResults.Text + "Testing BloodUnitTest.ConfirmationWorklistUnitGUID with {47E30D97-CA42-4563-A9FF-BE6E1832CD53}." + NEWLINE + NEWLINE;
				txtResults.Text = txtResults.Text + "Property set successfully." + NEWLINE + NEWLINE;
				try
				{
					txtResults.Text = txtResults.Text + "Testing BloodUnitTest.ConfirmationWorklistUnitGUID with {}." + NEWLINE + NEWLINE;
					throw(new ArgumentNullException("BOL.BloodUnitTest.ConfirmationWorklistUnitGUID"));
				}
				catch (ArgumentNullException ex)
				{
					txtResults.Text = txtResults.Text + "Failed setting property: " + ex.Message + NEWLINE;
				}
				//txtResults.Text = txtResults.Text + "Failed setting property - Argument Null Exception" + NEWLINE;
				txtResults.Text = txtResults.Text + NEWLINE + "Test completed successfully.";
			}
			catch (Exception ex)
			{
				txtResults.Text = txtResults.Text + NEWLINE + "Test FAILED! The following error occurred:" + NEWLINE + ex.Message;
			}
		}
	}
}
